[Setup]
;-- Main Setup Information
 AppName                = SQL Backup
 AppVerName             = SQL Backup 1.0.0.6
 AppCopyright           = Copyright  1995-2003 NetWorkDLS.
 DefaultDirName         = {pf}\NetWorkDLS\SQL Backup
 DefaultGroupName       = NetWorkDLS\SQL Backup
 UninstallDisplayIcon   = {app}\SQLBackup.Exe
 UninstallStyle         = Modern
 WizardImageFile        = Resources\LgSetup.bmp
 WizardSmallImageFile   = Resources\SmSetup.bmp
 PrivilegesRequired     = PowerUser
 Uninstallable          = Yes
 AppMutex               = SQL Backup
 LicenseFile            = Resources\EULA.txt
 compression            = ZIP/9
 OutputBaseFilename     = Setup
;UninstallLogMode       = OverWrite

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetWorkDLS
 AppPublisherURL = http://www.NetWorkDLS.com/
 AppUpdatesURL   = http://www.NetWorkDLS.com/
 AppVersion      = 1.0.0.6

[Files]
 Source: "..\Release\SQLBackup.Exe";          DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "SQLService\Release\SQLService.Exe"; DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "SBFInfo\Release\SBFInfo.Exe";       DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\EULA.txt";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Libraries\NASCCL.Dll";              DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Libraries\NDBSCore.Dll";            DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Libraries\NDBSFIO.Dll";             DestDir: "{app}"; Flags: IgnoreVersion;

[Dirs]
 Name: "{app}\Logs"
 Name: "{app}\Data"

[Registry]
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "Path";            ValueType: String; ValueData: "{app}";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "LogFileName";     ValueType: String; ValueData: "{app}\Logs\SQLBackup.Log";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "SavedDataFile";   ValueType: String; ValueData: "{app}\SQLBackup.Dat";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "AllOnHold";       ValueType: Dword;  ValueData: "0";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "DisplaySplash";   ValueType: Dword;  ValueData: "1";
 
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterDatabase";  ValueType: String; ValueData: "Master";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterDriver";    ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterPWS";       ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterServer";    ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterUID";       ValueType: String; ValueData: "sa";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupFile";      ValueType: String; ValueData: "{app}\Data\SQLRestore.sbf";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupDataBase";  ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupUserID";    ValueType: String; ValueData: "sa";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupUserPW";    ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupServer";    ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupDriver";    ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupTrusted";   ValueType: Dword;  ValueData: "1";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreFile";     ValueType: String; ValueData: "{app}\Data\SQLRestore.sbf";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreDataBase"; ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreUserID";   ValueType: String; ValueData: "sa";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreUserPW";   ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreServer";   ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreDriver";   ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreTrusted";  ValueType: Dword;  ValueData: "1";

;-- Create SBF Info Viewer File Assocation
 Root: HKCR; Subkey: ".sbf"; Flags: UninsDeleteKey
 Root: HKCR; Subkey: ".Sbf"; ValueType: String; ValueData: "sbffile";

 Root: HKCR; Subkey: "sbffile\DefaultIcon";  ValueType: String; ValueData: """{app}\SBFInfo.Exe"",0";
 Root: HKCR; Subkey: "sbffile\Shell"; ValueType: String; ValueData: "View";
 Root: HKCR; Subkey: "sbffile\Shell\View"; ValueType: String; ValueData: "View Information";
 Root: HKCR; Subkey: "sbffile\Shell\View\Command"; ValueType: String; ValueData: """{app}\SBFInfo.Exe"" %1";

[Run]
 Filename: "{app}\SQLService.EXE"; Parameters: "/install"; Description:"Register as service"; Flags:"PostInstall";
 Filename: "{app}\SQLService.EXE"; Parameters: "/start"; Description:"Start the service"; Flags:"PostInstall";

[UninstallRun]
 Filename: "{app}\SQLService.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"

